#include <cstdio>
#include <iostream>
#include <stack>
#include <algorithm>
#include <cmath>
using namespace std;

class Point {
public:
    int x, y;

    bool operator < (const Point &b) const {
        if (y != b.y)
            return y < b.y;
        return x < b.x;
    }
};

Point pivot;

int ccw(Point a, Point b, Point c) {
    int area = (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
    if (area > 0)
        return -1;
    else if (area < 0)
        return 1;
    return 0;
}

int distanca(Point p1, Point p2) {
    return (p1.x - p2.x)*(p1.x - p2.x) + (p1.y - p2.y)*(p1.y - p2.y);
}

int orientation(Point p, Point q, Point r) {
    int val = (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    if (val == 0) return 0;
    return (val > 0)? 1 : 2;
}

int compare(const void *vp1, const void *vp2) {
   Point *p1 = (Point *)vp1;
   Point *p2 = (Point *)vp2;
 
   int o = orientation(pivot, *p1, *p2);
   if (o == 0)
     return (distanca(pivot, *p2) >= distanca(pivot, *p1)) ? -1 : 1;
 
   return (o == 2) ? -1 : 1;
}

stack<Point> grahamScan(Point *points, int N) {
    stack<Point> hull;

    int leastY = 0;
    for (int i = 1; i < N; i++)
        if (points[i] < points[leastY])
            leastY = i;

    swap(points[0], points[leastY]);
    pivot = points[0];
    qsort(&points[1], N-1, sizeof(Point), compare);

    hull.push(points[0]);
    hull.push(points[1]);
    hull.push(points[2]);

    for (int i = 3; i < N; i++) {
        Point top = hull.top();
        hull.pop();
        while (ccw(hull.top(), top, points[i]) != -1) {
            top = hull.top();
            hull.pop();
        }
        hull.push(top);
        hull.push(points[i]);
    }
    return hull;
}

long long areaOfPolygon(stack<Point> hull) {
    long long area = 0;
    Point points[100000];
    int n = 0;

    while (!hull.empty()) {
        points[n++] = hull.top();
        hull.pop();
    }

    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        area += (long long)points[i].x * points[j].y;
        area -= (long long)points[i].y * points[j].x;
    }

    area = abs(area) / 2;
    return area;
}

long long convexHullWithNMinusOne(Point *points, int N) {
    stack<Point> fullHull = grahamScan(points, N);
    long long minArea = areaOfPolygon(fullHull);

    for (int i = 0; i < N; i++) {
        Point reducedPoints[100000];
        int idx = 0;
        for (int j = 0; j < N; j++) {
            if (i != j) {
                reducedPoints[idx++] = points[j];
            }
        }

        stack<Point> reducedHull = grahamScan(reducedPoints, N - 1);
        long long currentArea = areaOfPolygon(reducedHull);
        minArea = min(minArea, currentArea);
    }

    return minArea;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int N;
    cin >> N;
    Point points[N];

    for (int i = 0; i < N; i++) 
        cin >> points[i].x >> points[i].y;
    
    long long result = convexHullWithNMinusOne(points, N);
    printf("%lld\n", result);

    return 0;
}